<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Course extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    public function user()
    {
        return $this->hasMany('Course');
    }

    public function session()
    {
        return $this->belongsTo('Course');
    }

    public function properties()
    {
        return $this->belongsTo('Course');
    }

    public function tools()
    {
        return $this->belongsTo('Course');
    }

    public function attachments()
    {
        return $this->morphMany('Attachment');
    }

}